## PS-PyrosparkCore by Pyrospark Development ##
# Version 1.2.0
### Part of PyrosparkCore

Core utility resource for all Pyrospark Development resources. Provides shared commands, functions, and dependencies used across multiple resources.

## Features

- **Vehicle Commands**: Delete, move to driver seat, repair, refuel vehicles
- **Utility Commands**: Get coordinates, player info
- **VehicleHUD Integration**: Refuel command works with PS-VehicleHUD fuel system
- **Admin System**: Permission-based command access
- **Exported Functions**: Reusable functions for other resources
- **Fully Configurable**: Toggle features and customize behavior

## Installation

1. Download and place the entire `[Pyrospark-Core]` folder in your server's `resources` directory
2. Add the following to your `server.cfg`:
   ```cfg
   ensure [Pyrospark-Core]
   ```
3. Configure `config.lua` to your preferences (located in `[Pyrospark-Core]/PS-PyrosparkCore/config.lua`)
4. Restart your server

**Note:** The `[Pyrospark-Core]` resource group includes both PS-PyrosparkCore and [screenshot-basic by CitizenFX](https://github.com/citizenfx/screenshot-basic) for screenshot functionality.

## Commands

All commands use the `/ps` prefix followed by a subcommand:

**`/ps help`** - Show Available Commands
- Displays all commands you have permission to use
- Always available with base permission

### Vehicle Commands

**`/ps dv`** - Delete Vehicle
- Deletes the vehicle you're in or nearest vehicle (within 5m)
- Permission: `pyrosparkcore.ps.dv`

**`/ps seatdrive`** - Move to Driver Seat
- Teleports you to the driver seat of your current vehicle
- Permission: `pyrosparkcore.ps.seatdrive`

**`/ps fix`** - Repair Vehicle
- Fully repairs and cleans your current vehicle
- Permission: `pyrosparkcore.ps.fix`

**`/ps refuel`** - Refuel Vehicle
- Instantly refuels your current vehicle to 100%
- Requires PS-VehicleHUD to be installed and running
- Permission: `pyrosparkcore.ps.refuel`

**`/ps engine`** - Toggle Engine On/Off
- Toggles the vehicle engine on or off
- Only works if you are in the driver seat
- Permission: `pyrosparkcore.ps.engine`

### Utility Commands

**`/ps coords`** - Get Coordinates
- Prints your current coordinates to F8 console in vector3() and vector4() format
- Shows heading
- Permission: `pyrosparkcore.ps.coords`

**`/ps whoami`** - Show Player Info
- Displays your server ID, name, identifiers (Steam, License, Discord)
- Permission: `pyrosparkcore.ps.whoami`

## Permissions

PyrosparkCore uses FiveM's ACE permission system. Each command has its own permission that you can grant to specific players or groups.

### Quick Setup

Add these lines to your `server.cfg`:

```cfg
# Setup admin group
add_principal identifier.steam:YOUR_STEAM_ID group.admin

# IMPORTANT: Give access to the base /ps command first
add_ace builtin.everyone "pyrosparkcore.ps" allow

# Give everyone basic commands
add_ace builtin.everyone "pyrosparkcore.ps.dv" allow
add_ace builtin.everyone "pyrosparkcore.ps.seatdrive" allow
add_ace builtin.everyone "pyrosparkcore.ps.coords" allow
add_ace builtin.everyone "pyrosparkcore.ps.whoami" allow

# Restrict /ps fix, /ps refuel, and /ps engine to admins only
add_ace group.admin "pyrosparkcore.ps.fix" allow
add_ace group.admin "pyrosparkcore.ps.refuel" allow
add_ace group.admin "pyrosparkcore.ps.engine" allow
```

### Permission List

| Command | Permission | Recommended |
|---------|------------|-------------|
| `/ps` | `pyrosparkcore.ps` | Everyone (Required) |
| `/ps help` | `pyrosparkcore.ps` | Everyone |
| `/ps dv` | `pyrosparkcore.ps.dv` | Everyone |
| `/ps seatdrive` | `pyrosparkcore.ps.seatdrive` | Everyone |
| `/ps fix` | `pyrosparkcore.ps.fix` | Admins only |
| `/ps refuel` | `pyrosparkcore.ps.refuel` | Admins only |
| `/ps engine` | `pyrosparkcore.ps.engine` | Admins only |
| `/ps coords` | `pyrosparkcore.ps.coords` | Everyone |
| `/ps whoami` | `pyrosparkcore.ps.whoami` | Everyone |

### Alternative Configurations

**Give admins access to everything:**
```cfg
add_ace group.admin "pyrosparkcore.ps" allow
add_ace group.admin "pyrosparkcore.ps.*" allow
```

**Give everyone access to everything (not recommended):**
```cfg
add_ace builtin.everyone "pyrosparkcore.ps" allow
add_ace builtin.everyone "pyrosparkcore.ps.*" allow
```

**See `permissions.cfg` in the resource folder for more examples.**

## Configuration

Settings in `config.lua`:

### Vehicle Settings
```lua
Config.DeleteVehicleRange = 5.0        -- Max distance (meters)
Config.DeleteOwnedVehicles = false     -- Allow deleting owned vehicles
Config.DeleteEmptyOnly = false         -- Only delete empty vehicles
Config.FixFullRepair = true            -- Full repair
Config.FixCleansVehicle = true         -- Also clean/wash
```

## Exports

### Client Exports

**GetPlayerCoords()** - Returns: vector3(x, y, z)
```lua
local coords = exports['PS-PyrosparkCore']:GetPlayerCoords()
```

**GetPlayerCoordsHeading()** - Returns: vector4(x, y, z, heading)
```lua
local coords = exports['PS-PyrosparkCore']:GetPlayerCoordsHeading()
```

**DeleteNearestVehicle(range)** - Returns: boolean
```lua
local success = exports['PS-PyrosparkCore']:DeleteNearestVehicle(5.0)
```

**GetPlayerVehicle()** - Returns: vehicle entity or 0
```lua
local vehicle = exports['PS-PyrosparkCore']:GetPlayerVehicle()
```

**RepairVehicle()** - Returns: boolean
```lua
local success = exports['PS-PyrosparkCore']:RepairVehicle()
```

### Server Exports

**GetPlayerIdentifiers(source)** - Returns: table of identifiers
```lua
local identifiers = exports['PS-PyrosparkCore']:GetPlayerIdentifiers(source)
```

**GetPlayerIdentifier(source, type)** - Returns: string or nil
```lua
local steam = exports['PS-PyrosparkCore']:GetPlayerIdentifier(source, 'steam')
```

**GetOnlinePlayers()** - Returns: table of player sources
```lua
local players = exports['PS-PyrosparkCore']:GetOnlinePlayers()
```

## Dependencies

**Required by:**
- FleetManager (future)
- Other Pyrospark resources

**Requires:**
- None (standalone)

**Optional Integration:**
- PS-VehicleHUD - Required for `/ps refuel` command to work

## Credits

Created by Pyrospark Development, with assistance from AI

**Includes:**
- [screenshot-basic](https://github.com/citizenfx/screenshot-basic) by CitizenFX - Licensed under MIT

## License

Free to use, please do not re-distribute but direct to Pyrospark Development for downloads.
Modifications not permitted.

screenshot-basic retains its original MIT license from CitizenFX.
